/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.drive.ByteArrayDriveChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class MultiPurposeDriveChannel
extends ByteArrayDriveChannel {
    private static final int TYPE_SEQUENTIAL = 0;
    private static final int TYPE_USER = 1;
    private static final int TYPE_PROGRAM = 2;
    private static final int MODE_READ = 0;
    private static final int MODE_WRITE = 1;
    private static final int MODE_APPEND = 2;
    private boolean isBlockMode = false;
    private boolean isWriting = false;
    private String filename = null;

    public MultiPurposeDriveChannel(C1541 c1541) {
        super(c1541);
    }

    public void setBlockMode(boolean isBlockMode) {
        this.isBlockMode = isBlockMode;
    }

    @Override
    public void commit() throws IOException {
        if (!this.isWriting && !this.isBlockMode) {
            String fn = this.out.toString();
            int type = 0;
            int mode = 0;
            if (fn.indexOf(44) > 0) {
                int index = fn.indexOf(44);
                switch (fn.charAt(index + 1)) {
                    case 'S': {
                        break;
                    }
                    case 'P': {
                        type = 2;
                        break;
                    }
                    case 'U': {
                        type = 1;
                    }
                }
                index = fn.indexOf(44, index + 1);
                if (index > 0) {
                    switch (fn.charAt(index + 1)) {
                        case 'R': {
                            break;
                        }
                        case 'W': {
                            mode = 1;
                            break;
                        }
                        case 'A': {
                            mode = 2;
                        }
                    }
                }
                fn = fn.substring(0, fn.indexOf(44));
            }
            this.out.reset();
            if (!"#".equals(fn)) {
                if ((type == 0 || type == 2) && mode == 0) {
                    this.in = new ByteArrayInputStream(this.c1541.getDriveHandler().readFile(fn));
                } else if ((type == 0 || type == 2) && mode == 1) {
                    this.filename = fn;
                    this.isWriting = true;
                } else if ((type == 0 || type == 2) && mode == 2) {
                    byte[] bytes = this.c1541.getDriveHandler().readFile(fn);
                    this.out.write(bytes, 0, bytes.length);
                    this.filename = "@:" + fn;
                    this.isWriting = true;
                } else {
                    String message = "Illegal access mode or user type for file access '" + fn + "'!";
                    if (this.c1541.getLogger() != null) {
                        this.c1541.getLogger().warning(message);
                    }
                    throw new IOException(message);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isWriting) {
            this.c1541.getDriveHandler().writeFile(this.filename, this.out.toByteArray());
            this.isWriting = false;
        }
        super.close();
    }
}

